﻿var openEndAnalysisSentences = {
    context: $(".open-end-analysis-sentences"),
    dataTable: null,
    initialize: function () {
        openEndAnalysisSentences.initializeDataTable();
    },
    initializeDataTable: function () {
        var documentId = $("#DocumentId", openEndAnalysisSentences.context).val();
        openEndAnalysisSentences.dataTable = $(".data-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisSentences", "Analyze"),
            ajaxParams: { "documentId": documentId },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                { "Name": "Text", "Title": resources.OpenEnd, "HideInSelector": true, "Class": "text-column", "Data": openEndAnalysis.renderTextWithTopics },
                { "Name": "Score", "Title": resources.Score, "Width": "80px", "Type": "Number" },
                { "Name": "Sentiment", "Title": resources.Sentiment, "Width": "150px", "Class": "sentiment-column", "Data": openEndAnalysis.renderSentimentChart, "Sortable": false }
            ],
            contextMenuItems: [{ "Action": "topics", "Label": resources.Topics }],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "topics":
                        modalDialog.showWindow(a4.getSurveyAction("OpenEndAnalysisSentenceTopics", "Analyze", { sentenceId: row.Id }), 600);
                        break;
                };
            }
        });
    }
};

$(document).ready(function () {
    if (openEndAnalysisSentences.context.length > 0)
        openEndAnalysisSentences.initialize();
})